﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml.Linq;
using UnityEngine;

public class DecorationConfiguration : ConfigurationElement
{
    public Dictionary<string, DecorationProp> Props { get; private set; } = new Dictionary<string, DecorationProp>();   //Our props,  with an ID key and DecorationProp value

    public DecorationConfiguration() : base("Decoration")
    {

    }

    public override bool Parse(XElement configElem)
    {
        try
        {
            var propsXMLList = (from ele in configElem.Descendants("DecorationProp")
                                   select ele).ToList();    //Get all the prop elements

            for(int i = 0; i < propsXMLList.Count; i++)
            {
                DecorationProp thisDecorProp = new DecorationProp();

                XElement thisDecorPropElem = propsXMLList[i];
                if(thisDecorProp.Parse(thisDecorPropElem))  //Get the prop, let's try parsing it
                {
                    Props.Add(thisDecorProp.ID, thisDecorProp); //Not a duplicate so let's add it
                }

                else
                {
                    Debug.LogError(string.Format("ERROR: Failed to parse decoration prop index {0}. Perhaps the XML is malformed?", i));
                    return false;
                }
            }

            return true;
        }

        catch (Exception ex)
        {
            Debug.LogError("ERROR: Caught an exception when parsing decoration configuration. The exception is: " + ex);
            Preloader.ExceptionMessage = ex.ToString();
            return false;
        }
    }
}
